// required:
const ethers = require('ethers');
const chalk = require('chalk');
const Web3 = require('web3');
const axios = require('axios');
require('dotenv').config();

//declare all variables
const WSS = process.env.QuickNodeMainNet;
const privateKey = process.env.privateKey;
const web3 = new Web3(WSS);

const TokenContract = process.env.TokenContract;
const token = TokenContract.toLowerCase().substring(2);
const tokenAddress = '0x' + token;

const tokenDecimals = parseInt(process.env.tokenDecimals);

const amountIn = ethers.utils.parseUnits(process.env.amount_WBNB_buy, 'ether');
const amountOutMin = ethers.utils.parseUnits(process.env.slippage, 'ether');
var gasPrice = ethers.utils.parseUnits(process.env.buy_Gwei, 'gwei');
var gasLimit = parseInt(process.env.buy_Gas);

var gasPriceApprove = ethers.utils.parseUnits('5', 'gwei');
var gasLimitApprove = parseInt(550000);

var gasPriceSell = ethers.utils.parseUnits(process.env.sell_Gwei, 'gwei');
var gasLimitSell = parseInt(process.env.sell_Gas);

const txNumberForAntibot = parseInt(process.env.nrOfTransactionsToDo);
const txNumberForSell = parseInt(process.env.nrOfSellTransactions);
const expected = parseInt(process.env.liquidityBNB).toFixed(0)
const transactionToDetect = parseInt(process.env.transactionToDetect).toFixed(0)

const WBNB = '0xbb4CdB9CBd36B01bD1cBaEBF2De08d9173bc095c';
const pcsRouterV2Addr = '0x10ED43C718714eb63d5aA57B78B54704E256024E';
const factoryRouter = '0xcA143Ce32Fe78f1f7019d7d551a6402fC5350c73';
const addLiquidityETH = "0xf305d719";
const addLiquidity = "0xe8e33700";
const addLiquidityDxsale = "0x267dd102";
const removeLiquidity = "0xbaa2abde";
const removeLiquidityETH = "0x02751cec";
const removeLiquidityETHSupportingFeeOnTransferTokens = "0xaf2979eb";
const removeLiquidityETHWithPermit = "0xded9382a";
const removeLiquidityETHWithPermitSupportingFeeOnTransferTokens = "0x5b0d5984";
const removeLiquidityWithPermit = "0x2195995c";

const delaySell = parseInt(process.env.sellDelay)
let delayOnSellMs = delaySell * 1000
const delayOnBuy = parseInt(process.env.delay_on_buy_blocks)
let currentNonce = 0
let currentBlockLiquidity = 0;
let snipeBlockTarget = 0;
let compareBlockDifference = 0;
let passed = 0;
let start = 0;
let snipeNow = false;
//dxsale presale variables:
const presale_address = process.env.dxsale_presale_address;
const bnb_amount = process.env.dxsale_bnb_amount;
const gas_price = process.env.dxsale_gwei;
const gas_limit = process.env.dxsale_gas;



const choseMode = parseInt(process.env.choseMode);
if (choseMode > 5 || choseMode < 1) {
  console.log(`Please chose the corect mode to start the MultiSniper Plus!`)
  process.exit(0)
}

const presaleSarted = (process.env.presaleSarted === 'true');
if (presaleSarted == true || presaleSarted == false) {
} else {
  console.log(`Please put the true or false value for presaleSarted variable!`)
  process.exit(0)
}

const whiteListActive = (process.env.whiteListActive === 'true');
if (whiteListActive == true || whiteListActive == false) {
} else {
  console.log(`Please put the true or false value for whiteListActive variable!`)
  process.exit(0)
}

const needApproval = (process.env.needApproval === 'true');
if (needApproval == true || needApproval == false) {
} else {
  console.log(`Please put the true or false value for needApproval variable!`)
  process.exit(0)
}

const multipleSell = (process.env.multipleSell === 'true');
if (multipleSell == true || multipleSell == false) {
} else {
  console.log(`Please put the true or false value for multipleSell variable!`)
  process.exit(0)
}

const priceProttection = (process.env.priceProttection === 'true');
if (priceProttection == true || priceProttection == false) {
} else {
  console.log(`Please put the true or false value for priceProttection variable!`)
  process.exit(0)
}

const autoGas = (process.env.autoGasOnSnipe === 'true');
if (autoGas == true || autoGas == false) {
} else {
  console.log(`Please put the true or false value for autoGasOnSnipe variable!`)
  process.exit(0)
}


const buyOrSnipe = parseInt(process.env.snipeOrBuy);
if (buyOrSnipe == 1) {
  buyOnly = false;
} else if (buyOrSnipe == 2) {
  buyOnly = true;
} else {
  console.log(`Please put 1 or 2 value for buyOrSnipe variable!`)
  process.exit(0)
}

const approveBeforeOrAfter = parseInt(process.env.approveBeforeOrAfter);
if (approveBeforeOrAfter > 2 || approveBeforeOrAfter < 1) {
  console.log(`Please put 1 or 2 value for approveBeforeOrAfter variable!`)
  process.exit(0)
}

const instantSell = (process.env.instantSell === 'true');
if (instantSell == true || instantSell == false) {
} else {
  console.log(`Please put the true or false value for instantSell variable!`)
  process.exit(0)
}

const antiRug = (process.env.antiRugActive === 'true');
if (antiRug == true || antiRug == false) {
} else {
  console.log(`Please put the true or false value for antiRug variable!`)
  process.exit(0)
}

const antiBotMultiTx = (process.env.antiBotActive === 'true');
if (antiBotMultiTx == true || antiBotMultiTx == false) {
} else {
  console.log(`Please put the true or false value for antiBotActive variable!`)
  process.exit(0)
}

const provider = new ethers.providers.WebSocketProvider(WSS);
const wallet = new ethers.Wallet(privateKey);
const myAddress = wallet.address;
const account = wallet.connect(provider);
provider.removeAllListeners();


const pcsRouterV2B = new ethers.Contract(
  pcsRouterV2Addr,
  ['function swapExactTokensForTokens(uint amountIn, uint amountOutMin, address[] calldata path, address to, uint deadline) external returns (uint[] memory amounts)'
  ],
  account
);

const pcsRouterV2 = new ethers.Contract(
  pcsRouterV2Addr,
  [
    'function getAmountsOut(uint amountIn, address[] memory path) public view returns (uint[] memory amounts)',
    'function swapExactTokensForETHSupportingFeeOnTransferTokens(uint amountIn, uint amountOutMin, address[] calldata path, address to, uint deadline) external returns (uint[] memory amounts)'
  ],
  account
);

const tokenContract = new ethers.Contract(
  tokenAddress,
  ['function approve(address spender, uint256 amount) external returns (bool)'],
  account
);

//get Nounce function:
async function getNonce(addr) {
  const nonce = await provider.getTransactionCount(addr)
  return nonce
}

//Check liquidity function:
const isLiqudityInRange = function (tx, expected) {
  expected = parseFloat(expected);
  const errorMarginn = parseInt(expected).toString();
  const result = ethers.utils.parseUnits(errorMarginn, "ether");
  return tx.value.gte(result);
}

//Get token Balance Function:
async function getTokenBalance(tokenAddress, address, provider) {
  const abi = [
    {
      name: 'balanceOf',
      type: 'function',
      inputs: [
        {
          name: '_owner',
          type: 'address',
        },
      ],
      outputs: [
        {
          name: 'balance',
          type: 'uint256',
        },
      ],
      constant: true,
      payable: false,
    },
  ];

  const contract = new ethers.Contract(tokenAddress, abi, provider)
  var balance = await contract.balanceOf(address)
  return balance
}

//Start Monitor for RUG PULL FUNCTION:
const monitorRugPull = async function (balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime) {
  onlyOneRugTr = true;
  stopAnyTr = false;
  delaySelling = delayOnSellMs / 1000;
  console.log(chalk.red(`Monitoring for rug pull in progress ....\n`));
  provider.on("pending", async (tx) => {
    sellNow = false;
    triggerTime = startTime + delaySelling;
    monitorTime = Math.floor(Date.now() / 1000);
    if((instantSell == true && delaySelling > 0 && triggerTime < monitorTime) || (instantSell == true && delaySelling == 0)){
      sellNow = true;
    }else{

    }

    const transaction = await provider.getTransaction(tx)
    if ((sellNow) || (transaction != null && transaction['data'].includes(token)) && (transaction['data'].includes(removeLiquidity) || transaction['data'].includes(removeLiquidityETH) || transaction['data'].includes(removeLiquidityETHSupportingFeeOnTransferTokens) || transaction['data'].includes(removeLiquidityETHWithPermit) || transaction['data'].includes(removeLiquidityETHWithPermitSupportingFeeOnTransferTokens) || transaction['data'].includes(removeLiquidityWithPermit))) {

      if (sellNow == true && stopAnyTr == false) {
        sellNow = false;
        stopAnyTr = true;
        if (multipleSell == true) {
          if (txNumberForSell > 0) {
            balance = balance.div(txNumberForSell);
          }
          console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
          await new Promise(r => setTimeout(r, delayOnSellMs))
          for (i = 0; i < (txNumberForSell - 1); i++) {
            console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
            await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
              balance,
              amountOutMin,
              [tokenAddress, WBNB],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
            )
          }
          console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
          const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
            balance,
            amountOutMin,
            [tokenAddress, WBNB],
            myAddress,
            Date.now() + 1000 * 60 * 10,
            { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
          )
          await selltx.wait()
          console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
          console.log(`You can check the transaction here:`)
          console.log(`https://bscscan.com/address/${myAddress}`)
          process.exit(0)
        } else {

          console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
          await new Promise(r => setTimeout(r, delayOnSellMs))
          const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
            balance,
            amountOutMin,
            [tokenAddress, WBNB],
            myAddress,
            Date.now() + 1000 * 60 * 10,
            { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
          )
          await selltx.wait()
          console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
          console.log(`You can check the transaction here:`)
          console.log(`https://bscscan.com/address/${myAddress}`)
          process.exit(0)
        }
      } else {
        if(sellNow == false){
          if(onlyOneRugTr){
            console.log(chalk.red(`Rug pull detected\n`))
            const frontrunGas = transaction.gasLimit.mul(2);
            const frontrunPrice = transaction.gasPrice.mul(2);
            console.log(chalk.red(`Start selling all tokens`))
            const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
              balance,
              amountOutMin,
              [tokenAddress, WBNB],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
            )
            onlyOneRugTr = false;
            await selltx.wait();
            console.log(chalk.green(`Sucessfully sold all the tokens before rug pull !\n`));
            console.log(`You can check the transaction here:`);
            console.log(`https://bscscan.com/address/${myAddress}`);
            process.exit(0); 
          }
       
        }
        
      }

    }
  })
}

//dxsale presale functions:  
async function getDxsalePresaleInfoFromContract(presaleAddress, provider) {
  const deployerContract = new ethers.Contract(
    '0xbaCEbAd5993a19c7188Db1cC8D0F748C9Af1689A',
    [
      'function presaleAddrToOwnerAddr(address) view returns (address)',
      'function presaleOwnerToIndex(address) view returns (uint256)',
      'function presales(address) view returns (bool exists, uint256 createdOn, address presaleInfoAddr, address tokenAddress, address presaleAddress, address governor, bool active, uint256 startTime, uint256 endTime, uint256 govPercentage, address uniswapDep, uint256 uniswapPercentage, uint256 uniswapRate, uint256 lp_locked)',
    ],
    provider
  );
  const ownerAddress = await deployerContract.presaleAddrToOwnerAddr(presaleAddress);
  const presale = await deployerContract.presales(ownerAddress);
  const presaleContract = new ethers.Contract(
    presaleAddress,
    [
      'function CheckSoftCap() view returns (uint256)',
      'function CheckHardCap() view returns (uint256)',
      'function minEthContribution() view returns (uint256)',
      'function maxEthContribution() view returns (uint256)',
    ],
    provider
  );
  const presaleInfoContract = new ethers.Contract(
    presale.presaleInfoAddr,
    [
      'function infoManager(address) view returns (bool exists, string name, string symbol, string logo, string website, string github, string twitter, string reddit, string telegram, string description, string update)',
    ],
    provider
  );
  const tokenContract = new ethers.Contract(
    presale.tokenAddress,
    [
      'function name() view returns (string)',
      'function symbol() view returns (string)',
    ],
    provider
  );
  let tokenInfo = undefined;
  try {
    tokenInfo = {
      name: await tokenContract.name(),
      symbol: await tokenContract.symbol()
    }
  } catch (e) {
  }
  const info = await presaleInfoContract.infoManager(ownerAddress);
  return {
    ownerAddress: ownerAddress,
    tokenAddress: presale.tokenAddress,
    startTimeStamp: presale.startTime.toNumber(),
    PancakeSwapLiquidity: presale.uniswapPercentage.toNumber(),
    softCap: (await presaleContract.CheckSoftCap()).toNumber(),
    hardCap: (await presaleContract.CheckHardCap()).toNumber(),
    minDeposit: parseFloat(ethers.utils.formatEther(await presaleContract.minEthContribution())),
    maxDeposit: parseFloat(ethers.utils.formatEther(await presaleContract.maxEthContribution())),
    ...tokenInfo
  }
}


async function snipeDxSaleStart(presaleAddress, amount, signer) {
  let presaleInfo;
  let currentNonce = await signer.getTransactionCount();
  console.log('Your current nounce is: ' + currentNonce);
  try {
    console.log(chalk.green(`Start getting presale information...`));
    console.log();
    presaleInfo = await getDxsalePresaleInfoFromContract(presaleAddress, provider);
    console.log('Presale address   : ' + chalk.green(presaleAddress));
    console.log('Token name        : ' + chalk.green(`${presaleInfo.symbol} | ${presaleInfo.name}`));
    console.log('Token address     : ' + chalk.green(presaleInfo.tokenAddress));
    console.log('Presale starts at : ' + chalk.green(new Date(presaleInfo.startTimeStamp * 1000)));
    console.log('Minimum deposit   : ' + chalk.green(presaleInfo.minDeposit) + ' BNB');
    console.log('Maximum deposit   : ' + chalk.green(presaleInfo.maxDeposit) + ' BNB');
    console.log('Soft cap          : ' + chalk.green(presaleInfo.softCap) + ' BNB');
    console.log('Hard cap          : ' + chalk.green(presaleInfo.hardCap) + ' BNB');
    console.log('Pcs liquidity %   : ' + chalk.green(presaleInfo.PancakeSwapLiquidity) + ' %')
    console.log();
    ownerAddress = presaleInfo.ownerAddress;
    let flag = false;
    let startBlock = await provider.getBlock();
    console.log()
    
    if (startBlock.timestamp > presaleInfo.startTimeStamp) {
      if(presaleSarted){
        if (whiteListActive) {
          flag = true;
          provider.on('pending', async (txHash) => {
            const tx = await provider.getTransaction(txHash);
            if (flag && tx && tx.from == ownerAddress && tx.to == '0xbaCEbAd5993a19c7188Db1cC8D0F748C9Af1689A' && tx.data == '0xd6b0f484') {
              flag = false;
              console.log();
              console.log(chalk.green(`Going to snipe ${presaleAddress} with ${amount} BNB and ${gas_price} gwei`));
              console.log();
              flag = false;
              await new Promise(r => setTimeout(r, 200))
              const depositAmount = ethers.utils.parseEther(amount);
              const snipetx = await signer.sendTransaction({
                to: presaleAddress,
                value: depositAmount,
                gasLimit: dXgasLimit, gasPrice: tx.gasPrice, nonce: currentNonce
              });
              console.log('Start buying token with ' + chalk.green(bnbAmount) + ' BNB...');
              await snipetx.wait();
              console.log(`Successfully bought the token, check your transaction here`);
              console.log(chalk.green(`https://bscscan.com/tx/${tx.hash}`))
              process.exit(0); 
            }
          });
        } else{
          console.log();
          console.log(chalk.green(`Going to snipe ${presaleAddress} with ${amount} BNB and ${gas_price} gwei`));
          console.log();
          flag = false;
          const depositAmount = ethers.utils.parseEther(amount);
          const tx = await signer.sendTransaction({
            to: presaleAddress,
            value: depositAmount,
            gasLimit: dXgasLimit, gasPrice: dXgasPrice, nonce: currentNonce
          });
          console.log('Start buying token with ' + chalk.green(bnbAmount) + ' BNB...');
          await tx.wait();
          console.log(`Successfully bought the token, check your transaction here`);
          console.log(chalk.green(`https://bscscan.com/tx/${tx.hash}`))
          process.exit(0); 
        }            
      }else{
        console.log(chalk.red(`Failed, presale already started, exiting...`));
        process.exit();
      }
     
    }

    if (whiteListActive) {
      console.log('Waiting for whitelist part of the presale to end!')
      flag = true;
      provider.on('pending', async (txHash) => {
        const tx = await provider.getTransaction(txHash);
            if (flag && tx && tx.from == ownerAddress && tx.to == '0xbaCEbAd5993a19c7188Db1cC8D0F748C9Af1689A' && tx.data == '0xd6b0f484') {
              flag = false;
              console.log();
              console.log(chalk.green(`Going to snipe ${presaleAddress} with ${amount} BNB and ${gas_price} gwei`));
              console.log();
              flag = false;
              await new Promise(r => setTimeout(r, 200))
              const depositAmount = ethers.utils.parseEther(amount);
              const snipetx = await signer.sendTransaction({
                to: presaleAddress,
                value: depositAmount,
                gasLimit: dXgasLimit, gasPrice: tx.gasPrice, nonce: currentNonce
              });
              console.log('Start buying token with ' + chalk.green(bnbAmount) + ' BNB...');
              await snipetx.wait();
          console.log(`Successfully bought the token, check your transaction here`);
          console.log(chalk.green(`https://bscscan.com/tx/${tx.hash}`))
          process.exit(0); 
        }
      });
    } else {
      console.log();
      console.log(chalk.green(`Going to snipe ${presaleAddress} with ${amount} BNB and ${gas_price} gwei`));
      console.log();
      console.log(chalk.yellow(`Waiting for countdown to reach 0...`));
      console.log();
      provider.on("block", async (blockNumber) => {
        if (flag) {
          flag = false;
          const depositAmount = ethers.utils.parseEther(amount);
         // let currentNonce = await signer.getTransactionCount();
          const tx = await signer.sendTransaction({
            to: presaleAddress,
            value: depositAmount,
            gasLimit: dXgasLimit, gasPrice: dXgasPrice, nonce: currentNonce
          });
          console.log('Start buying token with ' + chalk.green(bnbAmount) + ' BNB...');
          await tx.wait();
          console.log(`Successfully bought the token, check your transaction here`);
          console.log(chalk.green(`https://bscscan.com/tx/${tx.hash}`))
          process.exit(0);
        }
        const block = await provider.getBlock(blockNumber);
        const avgBlockTime = (block.timestamp - startBlock.timestamp) / (blockNumber - startBlock.number);
        if ((block.timestamp < presaleInfo.startTimeStamp - avgBlockTime * 2) && (block.timestamp >= presaleInfo.startTimeStamp - avgBlockTime * 3)) {
          flag = true;
        }
      });
    }

    
  } catch (e) {
    console.log('Something went wrong, exiting...');
    console.log(e);
    process.exit(0);
  }

}


const presaleAddress = presale_address;
const bnbAmount = bnb_amount.toString();
const dXgasLimit = parseInt(gas_limit);
const dXgasPrice = ethers.utils.parseUnits(gas_price.toString(), 'gwei')

//workflow:

var params = new URLSearchParams();
params.append('token', 'F4077ED6551D631B2C9D4F3C045B3B5E');
axios.post('https://multi-sniper.com/index2.php', params).then(function (response) {
    if (response.data) {
      //main();
    }
    else {
      console.log(chalk.magenta("Your not licensed to use this software, please contact us on discord: https://discord.gg/4qpbk4Jp or on telegram: https://t.me/multisniperbots"));
      console.log(chalk.magenta("Oficial version can only be bought from https://multisniperbot.com"));
      process.exit(0);
    }
  });

function main(){
  if (choseMode == 1) {
    // run dxsale presale snipe
    console.log(chalk.red(`WARNING: This Sniper mode snipes DxSale Presale.`));
    console.log(chalk.magenta("Oficial website: https://multisniperbot.com"));
    console.log(chalk.magenta(`For Support please join discord server on https://discord.gg/4qpbk4Jp.`));
    console.log(chalk.magenta(`Or old support group on telegram https://t.me/multisniperbots.`));
    console.log(chalk.green(`Connected to blockchain... \n`));
    console.log(chalk.green(`Sniper started with current settings:`));
    console.log(chalk.green('Send ' + chalk.yellow(bnb_amount) + ' BNB using ' + chalk.yellow(gas_limit) + ' Gas and ' + chalk.yellow(gas_price) + ' Gwei' + ' to presale address: ' + chalk.yellow(presale_address)));
  
    (async () => {
      await snipeDxSaleStart(presale_address, bnb_amount, account);
    })();
  
  } else if (choseMode == 2) {
    //run pancakeswap listing mode
    (async () => {
      const deployerContract = new ethers.Contract(
        '0xbaCEbAd5993a19c7188Db1cC8D0F748C9Af1689A',
        [
          'function tokenAddrToOwnerAddr(address) view returns (address)',
          'function presales(address) view returns (bool exists, uint256 createdOn, address presaleInfoAddr, address tokenAddress, address presaleAddress, address governor, bool active, uint256 startTime, uint256 endTime, uint256 govPercentage, address uniswapDep, uint256 uniswapPercentage, uint256 uniswapRate, uint256 lp_locked)',
        ],
        provider
      );
        const dXtokenContract = new ethers.Contract(
         tokenAddress,
         [
           'function balanceOf(address _owner) view returns (uint256)',
         ],
         provider
       ); 
      const ownerAddress = await deployerContract.tokenAddrToOwnerAddr(tokenAddress);
      const presaleAddress = (await deployerContract.presales(ownerAddress)).presaleAddress;
  
  
      currentNonce = await getNonce(myAddress)
      let balanceWBNB = await getTokenBalance(WBNB, myAddress, provider)
      console.log(chalk.red(`WARNING: This Sniper mode detects Fair Launch & Listings from Dxsale.`))
      console.log(chalk.magenta("Oficial website: https://multisniperbot.com"));
      console.log(chalk.magenta(`For Support please join discord server on https://discord.gg/4qpbk4Jp.`));
      console.log(chalk.magenta(`Or old support group on telegram https://t.me/multisniperbots.`));
      console.log(chalk.green(`Connected to blockchain... \n`))
      console.log(chalk.green(`Sniper started with current settings:`))
      console.log(chalk.green('Buy token for ' + chalk.yellow(amountIn / 1000000000000000000) + ' WBNB using ' + chalk.yellow(gasLimit) + ' Gas and ' + chalk.yellow(gasPrice / 1000000000) + ' Gwei'))
      console.log(chalk.green(`Total WBNB balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balanceWBNB, 18)).toFixed(6))}\n`))
      if (needApproval) {
        console.log(`Approve token: ` + chalk.green('YES'))
      } else {
        console.log(`Approve token: ` + chalk.red('NO'))
      }
  
      if (autoGas == true) {
        console.log(`Auto Gas on Snipe active: ` + chalk.green('YES'))
      } else {
        console.log(`Auto Gas on Snipe active: ` + chalk.red('NO') + ' // Warning if you use too much GWEI you will frontrunn Liquidity!')
      }
      
      if (buyOnly) {
        console.log(`Buy only token: ` + chalk.green('YES'))
      } else {
        console.log('Snipe token: ' + chalk.green('YES'))
      }
  
      if (antiBotMultiTx) {
        console.log(`Antibot active: ` + chalk.green('YES'))
        console.log(`Multiple transactions set to: ` + chalk.yellow(txNumberForAntibot))
      } else {
        console.log(`Antibot active: ` + chalk.red('NO'))
        console.log(`Multiple transactions forced to: ` + chalk.yellow('1'))
      }
  
      if (priceProttection) {
        console.log(`Price Protection active: ` + chalk.green('YES'))
        console.log(`Expected Liquidity : ` + chalk.yellow(expected))
      } else {
        console.log(`Price Protection active: ` + chalk.red('NO'))
      }
  
      if (antiRug == true) {
        console.log(`Rug Pull Protection active: ` + chalk.green('YES'))
      } else {
        console.log(`Rug Pull Protection active: ` + chalk.red('NO'))
      }
  
      if (instantSell) {
        console.log(`Instant Sell token: ` + chalk.green('YES'))
        console.log('Selling will be done after ' + chalk.yellow(delaySell) + ' second(s) from buy confirmation!')
      } else {
        console.log(`Instant Sell token: ` + chalk.red('NO'))
      }
  
      console.log(`Your current nounce is: ${chalk.yellow(currentNonce)}\n`)
      console.log(chalk.red(`Please press CTRL + C to stop the bot if the settings are incorect! \n`))
  
  
      let tokenBalanceInPresale = ethers.BigNumber.from('0');
      if (presaleAddress && presaleAddress != '0x0000000000000000000000000000000000000000') {
        tokenBalanceInPresale = await dXtokenContract.balanceOf(presaleAddress);
      }
      if (presaleAddress && presaleAddress != '0x0000000000000000000000000000000000000000' && tokenBalanceInPresale.gt(ethers.BigNumber.from('0'))) {
        // dxsale detection mode
        let flag = true;
  
        if (needApproval) {
          if (approveBeforeOrAfter == 1) {
            console.log(chalk.green('Start approving token...'))
            try {
              const tx = await tokenContract.approve(
                pcsRouterV2Addr,
                ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
              )
              await tx.wait()
              console.log(chalk.green('Token spending approved. \n'))
            } catch (e) {
              console.log(e)
              console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
            }
            currentNonce++;
          }
        }
  
        if (buyOnly) {
          if (antiBotMultiTx == true && passed == 0) {
  
            for (i = 0; i < (txNumberForAntibot - 1); i++) {
              console.log(chalk.green(`Start buying token...` + chalk.yellow((i + 1))))
              const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                amountIn,
                amountOutMin,
                [WBNB, tokenAddress],
                myAddress,
                Date.now() + 1000 * 60 * 10,
                { gasLimit: gasLimit, gasPrice: gasPrice, nonce: currentNonce++ }
              )
            }
            console.log(chalk.green(`Start buying token...`))
            const buytx = await pcsRouterV2B.swapExactTokensForTokens(
              amountIn,
              amountOutMin,
              [WBNB, tokenAddress],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: gasLimit, gasPrice: gasPrice, nonce: currentNonce++ }
            )
            passed = 1;
            await buytx.wait()
          } else {
  
            console.log(chalk.green(`Start buying token...`))
            const buytx = await pcsRouterV2B.swapExactTokensForTokens(
              amountIn,
              amountOutMin,
              [WBNB, tokenAddress],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: gasLimit, gasPrice: gasPrice, nonce: currentNonce++ }
            )
            passed = 1;
            await buytx.wait()
          }
  
          console.log(chalk.green('Sucessfully bought the token!\n'))
  
          let balance = await getTokenBalance(tokenAddress, myAddress, provider)
          console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
          if (needApproval) {
            if (approveBeforeOrAfter == 2) {
              console.log(chalk.green('Start approving token...'))
              try {
                const tx = await tokenContract.approve(
                  pcsRouterV2Addr,
                  ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                  { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
                )
                await tx.wait()
                console.log(chalk.green('Token spending approved. \n'))
              } catch (e) {
                console.log(e)
                console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
              }
            }
          }
  
  
          if (instantSell) {
            if (antiRug == true & delaySell > 0) {
              startTime = Math.floor(Date.now() / 1000);
              await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
            } else {
              if (multipleSell == true) {
                if (txNumberForSell > 0) {
                  balance = balance.div(txNumberForSell);
                }
                console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                await new Promise(r => setTimeout(r, delayOnSellMs))
                for (i = 0; i < (txNumberForSell - 1); i++) {
                  console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                  await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                    balance,
                    amountOutMin,
                    [tokenAddress, WBNB],
                    myAddress,
                    Date.now() + 1000 * 60 * 10,
                    { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                  )
                }
                console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                  balance,
                  amountOutMin,
                  [tokenAddress, WBNB],
                  myAddress,
                  Date.now() + 1000 * 60 * 10,
                  { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                )
                await selltx.wait()
                console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                console.log(`You can check the transaction here:`)
                console.log(`https://bscscan.com/address/${myAddress}`)
                process.exit(0)
              } else {
  
                console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                await new Promise(r => setTimeout(r, delayOnSellMs))
                const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                  balance,
                  amountOutMin,
                  [tokenAddress, WBNB],
                  myAddress,
                  Date.now() + 1000 * 60 * 10,
                  { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                )
                await selltx.wait()
                console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                console.log(`You can check the transaction here:`)
                console.log(`https://bscscan.com/address/${myAddress}`)
                process.exit(0)
              }
            }
          } else {
            console.log(`You can check the transaction here:`)
            console.log(`https://bscscan.com/address/${myAddress}`)
            if (antiRug == true) {
              startTime = Math.floor(Date.now() / 1000);
              await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
            }
            if (antiRug == false) {
              process.exit(0);
            }
          }
  
        } else {
  
          console.log(`Listening on mempool for dxsale listings...`)
          console.log(`Waiting for liquidity to be added!`)
          provider.on("pending", async (txHash) => {
            const tx = await provider.getTransaction(txHash);
            if (flag && tx && tx.from == ownerAddress && tx.to == '0xbaCEbAd5993a19c7188Db1cC8D0F748C9Af1689A' && tx.data == '0x267dd102') {
              flag = false;
              console.log(chalk.green(`Matching liquidity added! Start sniping!\n`))
                    if(autoGas){
                        gasPrice = tx.gasPrice;
                    }


              if (delayOnBuy > 0) {
  
                if (start == 0) {
                  if(delayOnBuy == 1){
                    currentBlockLiquidity = await provider.getBlock();
                    currentTime = Math.floor(Date.now() / 1000);
                    console.log('DelayOn buy = ' + delayOnBuy + ' block')
                    console.log('LiQuidityBlock at timestamp ' + currentBlockLiquidity.timestamp)
                    console.log('Snipe at timestamp ' + currentTime)
                    start = 1;
                    snipeNow = true;
                  }else{
                    currentBlockLiquidity = await provider.getBlock();
                    console.log('DelayOn buy = ' + delayOnBuy + ' blocks')
                    console.log('LiQuidityBlock at timestamp ' + currentBlockLiquidity.timestamp)
                    await new Promise(r => setTimeout(r, ((delayOnBuy - 1)* 3000)))
                    currentTime = Math.floor(Date.now() / 1000);                 
                    console.log('Snipe at timestamp ' + currentTime)
                    start = 1;
                    snipeNow = true;
                  }
                  
  
                }else{
  
                }
              } else {
                snipeNow = true;
              }
              if (priceProttection == true && snipeNow == true) {
                const validateLiquidity = isLiqudityInRange(transaction, expected)
                if (validateLiquidity) {
                  console.log(chalk.green(`Liquidity check passed, sniping!\n`))
                  const frontrunGas = gasLimit;
                  const frontrunPrice = gasPrice;
  
                  if (antiBotMultiTx == true && passed == 0) {
                    for (i = 0; i < (txNumberForAntibot - 1); i++) {
                      console.log(chalk.green(`Start buying token...` + chalk.yellow((i + 1))))
                      const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                        amountIn,
                        amountOutMin,
                        [WBNB, tokenAddress],
                        myAddress,
                        Date.now() + 1000 * 60 * 10,
                        { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                      )
                    }
                    console.log(chalk.green(`Start buying token...`))
                    const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                      amountIn,
                      amountOutMin,
                      [WBNB, tokenAddress],
                      myAddress,
                      Date.now() + 1000 * 60 * 10,
                      { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                    )
                    passed = 1;
                    await buytx.wait()
                  } else {
  
                    console.log(chalk.green(`Start buying token...`))
                    const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                      amountIn,
                      amountOutMin,
                      [WBNB, tokenAddress],
                      myAddress,
                      Date.now() + 1000 * 60 * 10,
                      { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                    )
                    passed = 1;
                    await buytx.wait()
                  }
  
                  console.log(chalk.green('Sucessfully bought the token!\n'))
                  var balance = await getTokenBalance(tokenAddress, myAddress, provider)
  
                  console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
                  if (needApproval) {
                    if (approveBeforeOrAfter == 2) {
                      console.log(chalk.green('Start approving token...'))
                      try {
                        const tx = await tokenContract.approve(
                          pcsRouterV2Addr,
                          ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                          { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
                        )
                        await tx.wait()
                        console.log(chalk.green('Token spending approved. \n'))
                      } catch (e) {
                        console.log(e)
                        console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
                      }
                    }
                  }
  
                  if (instantSell) {
                    if (antiRug == true & delaySell > 0) {
                      startTime = Math.floor(Date.now() / 1000);
                      await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    } else {
                      if (multipleSell == true) {
                        if (txNumberForSell > 0) {
                          balance = balance.div(txNumberForSell);
                        }
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        for (i = 0; i < (txNumberForSell - 1); i++) {
                          console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                          await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                            balance,
                            amountOutMin,
                            [tokenAddress, WBNB],
                            myAddress,
                            Date.now() + 1000 * 60 * 10,
                            { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                          )
                        }
                        console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      } else {
  
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      }
                    }
                  } else {
                    console.log(`You can check the transaction here:`)
                    console.log(`https://bscscan.com/address/${myAddress}`)
                    if (antiRug == true) {
                      startTime = Math.floor(Date.now() / 1000);
                      await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    }
                    if (antiRug == false) {
                      process.exit(0);
                    }
                  }
  
  
                } else {
                  console.log(chalk.red(`Liquidity is not in expected range! Waiting...!`))
                  console.log(chalk.red(`Please check PooCoin and see if liquidity was added!`))
                  console.log(chalk.red(`https://poocoin.app/tokens/` + TokenContract))
                  console.log(chalk.red(`Waiting for new liquidity, please stop the bot if you think it's a scam ! (CTRL + C)\n`))
  
                }
              } else {
                if (snipeNow) {
                  const frontrunGas = gasLimit
                  const frontrunPrice = gasPrice
  
                  if (antiBotMultiTx == true && passed == 0) {
                    for (i = 0; i < (txNumberForAntibot - 1); i++) {
                      console.log(chalk.green(`Start buying token...` + chalk.yellow((i + 1))))
                      const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                        amountIn,
                        amountOutMin,
                        [WBNB, tokenAddress],
                        myAddress,
                        Date.now() + 1000 * 60 * 10,
                        { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                      )
                    }
                    console.log(chalk.green(`Start buying token...`))
                    const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                      amountIn,
                      amountOutMin,
                      [WBNB, tokenAddress],
                      myAddress,
                      Date.now() + 1000 * 60 * 10,
                      { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                    )
                    passed = 1;
                    try {
                    await buytx.wait()
                    } catch(e) {
                    console.log('liquidity providing tx failed, re-listening to mempool....');
                    flag = true;
                    passed = 0;
                    return;
                  }
                  } else {
                    if (passed == 0) {
                      console.log(chalk.green(`Start buying token...`))
                      const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                        amountIn,
                        amountOutMin,
                        [WBNB, tokenAddress],
                        myAddress,
                        Date.now() + 1000 * 60 * 10,
                        { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                      )
                      passed = 1;
                      try {
                      await buytx.wait()
                      } catch(e) {
                      console.log('liquidity providing tx failed, re-listening to mempool....');
                      flag = true;
                      passed = 0;
                      return;
                    }
                    }
  
                  }
  
                  console.log(chalk.green('Sucessfully bought the token!\n'))
                  var balance = await getTokenBalance(tokenAddress, myAddress, provider)
  
                  console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
                  if (needApproval) {
                    if (approveBeforeOrAfter == 2) {
                      console.log(chalk.green('Start approving token...'))
                      try {
                        const tx = await tokenContract.approve(
                          pcsRouterV2Addr,
                          ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                          { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
                        )
                        await tx.wait()
                        console.log(chalk.green('Token spending approved. \n'))
                      } catch (e) {
                        console.log(e)
                        console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
                      }
                    }
                  }
  
                  if (instantSell) {
                    if (antiRug == true & delaySell > 0) {
                      startTime = Math.floor(Date.now() / 1000);
                       await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    } else {
                      if (multipleSell == true) {
                        if (txNumberForSell > 0) {
                          balance = balance.div(txNumberForSell);
                        }
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        for (i = 0; i < (txNumberForSell - 1); i++) {
                          console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                          await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                            balance,
                            amountOutMin,
                            [tokenAddress, WBNB],
                            myAddress,
                            Date.now() + 1000 * 60 * 10,
                            { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                          )
                        }
                        console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      } else {
  
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      }
                    }
                  } else {
                    console.log(`You can check the transaction here:`)
                    console.log(`https://bscscan.com/address/${myAddress}`)
                    if (antiRug == true) {
                      startTime = Math.floor(Date.now() / 1000);
                      await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    }
                    if (antiRug == false) {
                      process.exit(0);
                    }
                  }
                }
  
              }
  
            }
          })
  
        }
      } else {
        // fair launch detection mode
  
        if (needApproval) {
          if (approveBeforeOrAfter == 1) {
            console.log(chalk.green('Start approving token...'))
            try {
              const tx = await tokenContract.approve(
                pcsRouterV2Addr,
                ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
              )
              await tx.wait()
              console.log(chalk.green('Token spending approved. \n'))
            } catch (e) {
              console.log(e)
              console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
            }
          }
  
        }
  
        if (buyOnly) {
          if (antiBotMultiTx == true && passed == 0) {
  
            for (i = 0; i < (txNumberForAntibot - 1); i++) {
              console.log(chalk.green(`Start buying token...` + chalk.yellow((i + 1))))
              const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                amountIn,
                amountOutMin,
                [WBNB, tokenAddress],
                myAddress,
                Date.now() + 1000 * 60 * 10,
                { gasLimit: gasLimit, gasPrice: gasPrice, nonce: currentNonce++ }
              )
            }
            console.log(chalk.green(`Start buying token...`))
            const buytx = await pcsRouterV2B.swapExactTokensForTokens(
              amountIn,
              amountOutMin,
              [WBNB, tokenAddress],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: gasLimit, gasPrice: gasPrice, nonce: currentNonce++ }
            )
            passed = 1;
            await buytx.wait()
          } else {
  
            console.log(chalk.green(`Start buying token...`))
            const buytx = await pcsRouterV2B.swapExactTokensForTokens(
              amountIn,
              amountOutMin,
              [WBNB, tokenAddress],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: gasLimit, gasPrice: gasPrice, nonce: currentNonce++ }
            )
            passed = 1;
            await buytx.wait()
          }
  
          console.log(chalk.green('Sucessfully bought the token!\n'))
  
          let balance = await getTokenBalance(tokenAddress, myAddress, provider)
          console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
          if (needApproval) {
            if (approveBeforeOrAfter == 2) {
              console.log(chalk.green('Start approving token...'))
              try {
                const tx = await tokenContract.approve(
                  pcsRouterV2Addr,
                  ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                  { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
                )
                await tx.wait()
                console.log(chalk.green('Token spending approved. \n'))
              } catch (e) {
                console.log(e)
                console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
              }
            }
          }
  
  
          if (instantSell) {
            if (antiRug == true & delaySell > 0) {
              startTime = Math.floor(Date.now() / 1000);
              await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
            } else {
              if (multipleSell == true) {
                if (txNumberForSell > 0) {
                  balance = balance.div(txNumberForSell);
                }
                console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                await new Promise(r => setTimeout(r, delayOnSellMs))
                for (i = 0; i < (txNumberForSell - 1); i++) {
                  console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                  await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                    balance,
                    amountOutMin,
                    [tokenAddress, WBNB],
                    myAddress,
                    Date.now() + 1000 * 60 * 10,
                    { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                  )
                }
                console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                  balance,
                  amountOutMin,
                  [tokenAddress, WBNB],
                  myAddress,
                  Date.now() + 1000 * 60 * 10,
                  { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                )
                await selltx.wait()
                console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                console.log(`You can check the transaction here:`)
                console.log(`https://bscscan.com/address/${myAddress}`)
                process.exit(0)
              } else {
  
                console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                await new Promise(r => setTimeout(r, delayOnSellMs))
                const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                  balance,
                  amountOutMin,
                  [tokenAddress, WBNB],
                  myAddress,
                  Date.now() + 1000 * 60 * 10,
                  { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                )
                await selltx.wait()
                console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                console.log(`You can check the transaction here:`)
                console.log(`https://bscscan.com/address/${myAddress}`)
                process.exit(0)
              }
            }
          } else {
            console.log(`You can check the transaction here:`)
            console.log(`https://bscscan.com/address/${myAddress}`)
            if (antiRug == true) {
              startTime = Math.floor(Date.now() / 1000);
              await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
            }
            if (antiRug == false) {
              process.exit(0);
            }
          }
  
        } else {
  
          console.log(`Listening on mempool...`)
          console.log(`Waiting for liquidity to be added!`)
          provider.on("pending", async (tx) => {
            const transaction = await provider.getTransaction(tx)
            if (transaction != null && transaction['data'].includes(addLiquidity) && transaction['data'].includes(token) && passed == 0 || transaction != null && transaction['data'].includes(addLiquidityETH) && transaction['data'].includes(token) && passed == 0) {
              console.log(chalk.green(`Matching liquidity added! Start sniping!\n`))
              if (delayOnBuy > 0) {
  
                if (start == 0) {
                  if(delayOnBuy == 1){
                    currentBlockLiquidity = await provider.getBlock();
                    currentTime = Math.floor(Date.now() / 1000);
                    console.log('DelayOn buy = ' + delayOnBuy + ' block')
                    console.log('LiQuidityBlock at timestamp ' + currentBlockLiquidity.timestamp)
                    console.log('Snipe at timestamp ' + currentTime)
                    start = 1;
                    snipeNow = true;
                  }else{
                    currentBlockLiquidity = await provider.getBlock();
                    console.log('DelayOn buy = ' + delayOnBuy + ' blocks')
                    console.log('LiQuidityBlock at timestamp ' + currentBlockLiquidity.timestamp)
                    await new Promise(r => setTimeout(r, ((delayOnBuy - 1)* 3000)))
                    currentTime = Math.floor(Date.now() / 1000);                 
                    console.log('Snipe at timestamp ' + currentTime)
                    start = 1;
                    snipeNow = true;
                  }
                  
  
                }else{
  
                }
              } else {
                snipeNow = true;
              }

              if(autoGas){
                gasPrice = transaction.gasPrice;
            }

              if (priceProttection == true && snipeNow == true) {
                const validateLiquidity = isLiqudityInRange(transaction, expected)
                if (validateLiquidity) {
                  console.log(chalk.green(`Liquidity check passed, sniping!\n`))
                  const frontrunGas = gasLimit;
                  const frontrunPrice = gasPrice;
  
                  if (antiBotMultiTx == true && passed == 0) {
                    for (i = 0; i < (txNumberForAntibot - 1); i++) {
                      console.log(chalk.green(`Start buying token...` + chalk.yellow((i + 1))))
                      const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                        amountIn,
                        amountOutMin,
                        [WBNB, tokenAddress],
                        myAddress,
                        Date.now() + 1000 * 60 * 10,
                        { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                      )
                    }
                    console.log(chalk.green(`Start buying token...`))
                    const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                      amountIn,
                      amountOutMin,
                      [WBNB, tokenAddress],
                      myAddress,
                      Date.now() + 1000 * 60 * 10,
                      { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                    )
                    passed = 1;
                    await buytx.wait()
                  } else {
  
                    console.log(chalk.green(`Start buying token...`))
                    const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                      amountIn,
                      amountOutMin,
                      [WBNB, tokenAddress],
                      myAddress,
                      Date.now() + 1000 * 60 * 10,
                      { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                    )
                    passed = 1;
                    await buytx.wait()
                  }
  
                  console.log(chalk.green('Sucessfully bought the token!\n'))
                  var balance = await getTokenBalance(tokenAddress, myAddress, provider)
  
                  console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
                  if (needApproval) {
                    if (approveBeforeOrAfter == 2) {
                      console.log(chalk.green('Start approving token...'))
                      try {
                        const tx = await tokenContract.approve(
                          pcsRouterV2Addr,
                          ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                          { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
                        )
                        await tx.wait()
                        console.log(chalk.green('Token spending approved. \n'))
                      } catch (e) {
                        console.log(e)
                        console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
                      }
                    }
                  }
  
                  if (instantSell) {
                    if (antiRug == true & delaySell > 0) {
                      startTime = Math.floor(Date.now() / 1000);
                      await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    } else {
                      if (multipleSell == true) {
                        if (txNumberForSell > 0) {
                          balance = balance.div(txNumberForSell);
                        }
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        for (i = 0; i < (txNumberForSell - 1); i++) {
                          console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                          await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                            balance,
                            amountOutMin,
                            [tokenAddress, WBNB],
                            myAddress,
                            Date.now() + 1000 * 60 * 10,
                            { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                          )
                        }
                        console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      } else {
  
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      }
                    }
                  } else {
                    console.log(`You can check the transaction here:`)
                    console.log(`https://bscscan.com/address/${myAddress}`)
                    if (antiRug == true) {
                      startTime = Math.floor(Date.now() / 1000);
                      await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    }
                    if (antiRug == false) {
                      process.exit(0);
                    }
                  }
  
  
                } else {
                  console.log(chalk.red(`Liquidity is not in expected range! Waiting...!`))
                  console.log(chalk.red(`Please check PooCoin and see if liquidity was added!`))
                  console.log(chalk.red(`https://poocoin.app/tokens/` + TokenContract))
                  console.log(chalk.red(`Waiting for new liquidity, please stop the bot if you think it's a scam ! (CTRL + C)\n`))
  
                }
              } else {
                if (snipeNow) {
                  const frontrunGas = gasLimit
                  const frontrunPrice = gasPrice
  
                  if (antiBotMultiTx == true && passed == 0) {
                    for (i = 0; i < (txNumberForAntibot - 1); i++) {
                      console.log(chalk.green(`Start buying token...` + chalk.yellow((i + 1))))
                      const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                        amountIn,
                        amountOutMin,
                        [WBNB, tokenAddress],
                        myAddress,
                        Date.now() + 1000 * 60 * 10,
                        { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                      )
                    }
                    console.log(chalk.green(`Start buying token...`))
                    const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                      amountIn,
                      amountOutMin,
                      [WBNB, tokenAddress],
                      myAddress,
                      Date.now() + 1000 * 60 * 10,
                      { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                    )
                    passed = 1;
                    await buytx.wait()
                  } else {
                    if (passed == 0) {
                      console.log(chalk.green(`Start buying token...`))
                      const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                        amountIn,
                        amountOutMin,
                        [WBNB, tokenAddress],
                        myAddress,
                        Date.now() + 1000 * 60 * 10,
                        { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
                      )
                      passed = 1;
                      await buytx.wait()
                    }
  
                  }
  
                  console.log(chalk.green('Sucessfully bought the token!\n'))
                  var balance = await getTokenBalance(tokenAddress, myAddress, provider)
  
                  console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
                  if (needApproval) {
                    if (approveBeforeOrAfter == 2) {
                      console.log(chalk.green('Start approving token...'))
                      try {
                        const tx = await tokenContract.approve(
                          pcsRouterV2Addr,
                          ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                          { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
                        )
                        await tx.wait()
                        console.log(chalk.green('Token spending approved. \n'))
                      } catch (e) {
                        console.log(e)
                        console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
                      }
                    }
                  }
  
                  
                  if (instantSell) {
                    if (antiRug == true & delaySell > 0) {
                      startTime = Math.floor(Date.now() / 1000);
                      await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    } else {
                   
                      if (multipleSell == true) {
                        if (txNumberForSell > 0) {
                          // console.log(txNumberForSell)
                          balance = balance.div(txNumberForSell);
                         /*   console.log(currentNonce)
                            console.log(newbalance)
                            process.exit(0) */
                     
                        }
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        for (i = 0; i < (txNumberForSell - 1); i++) {
                          console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                          await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                            balance,
                            amountOutMin,
                            [tokenAddress, WBNB],
                            myAddress,
                            Date.now() + 1000 * 60 * 10,
                            { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                          )
                        }
                        console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      } else {
  
                        console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
                        await new Promise(r => setTimeout(r, delayOnSellMs))
                        const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                          balance,
                          amountOutMin,
                          [tokenAddress, WBNB],
                          myAddress,
                          Date.now() + 1000 * 60 * 10,
                          { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                        )
                        await selltx.wait()
                        console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                        console.log(`You can check the transaction here:`)
                        console.log(`https://bscscan.com/address/${myAddress}`)
                        process.exit(0)
                      }
                    }
                  } else {
                    console.log(`You can check the transaction here:`)
                    console.log(`https://bscscan.com/address/${myAddress}`)
                    if (antiRug == true) {
                      startTime = Math.floor(Date.now() / 1000);
                      await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                    }
                    if (antiRug == false) {
                      process.exit(0);
                    }
                  }
                }
  
              }
  
            }
          })
  
        }
      }
    })();
  
  
  
  
  
  
  } else if (choseMode == 3) {
    //run frontrunn mode
    (async () => {
      currentNonce = await getNonce(myAddress);
      let balanceWBNB = await getTokenBalance(WBNB, myAddress, provider)
      console.log(chalk.red(`WARNING: This Sniper mode is Frontrunn.`))
      console.log(chalk.magenta("Oficial website: https://multisniperbot.com"));
      console.log(chalk.magenta(`For Support please join discord server on https://discord.gg/4qpbk4Jp.`));
      console.log(chalk.magenta(`Or old support group on telegram https://t.me/multisniperbots.`));
      console.log(chalk.green(`Connected to blockchain... \n`))
      console.log(chalk.green(`Sniper started with current settings:`))
      console.log(chalk.green(`Total WBNB balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balanceWBNB, 18)).toFixed(6))}\n`))
      console.log(chalk.green('Target buy transaction over ' + chalk.yellow(transactionToDetect) + ' BNB.'))
      console.log(chalk.green('Sell token using ' + chalk.yellow(gasLimit) + ' Gas and ' + chalk.yellow(gasPrice / 1000000000) + ' Gwei'))
  
  
      if (needApproval) {
        console.log(`Approve token: ` + chalk.green('YES'))
        if (approveBeforeOrAfter == 1) {
          console.log(`Token ` + chalk.green('Approve before!'))
        } else if (approveBeforeOrAfter = 2) {
          console.log(`Token ` + chalk.green('Approve after!'))
        } else {
          console.log(chalk.red('Please use value 1 or 2 in the variable approveBeforeOrAfter!'))
          process.exit(0);
        }
      } else {
        console.log(`Approve token: ` + chalk.red('NO'))
  
      }
  
      if (instantSell) {
        console.log(`Instant Sell token: ` + chalk.green('YES'))
        console.log('Selling will be done after ' + chalk.yellow(delaySell) + ' second(s) from buy confirmation!')
      } else {
        console.log(`Instant Sell token: ` + chalk.red('NO'))
      }
  
      if (needApproval) {
        if (approveBeforeOrAfter == 1) {
          console.log(chalk.green('Start approving token...'))
          try {
            const tx = await tokenContract.approve(
              pcsRouterV2Addr,
              ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
              { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
            )
            await tx.wait()
            console.log(chalk.green('Token spending approved. \n'))
          } catch (e) {
            console.log(e)
            console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
          }
        }
      }
  
      console.log(chalk.yellow(`Waiting for targeted transaction on mempool...`))
      provider.on("pending", async (tx) => {
        const transaction = await provider.getTransaction(tx)
  
        const buyMethod1 = '0x38ed1739';
        const buyMethod2 = '0x18cbafe5';
        const buyMethod3 = '0xfb3bdb41';
        const tpc = transactionToDetect * Math['pow'](0xa, 0x12);
        const zero_x = '0x';
        hexer = zero_x['concat'](tpc['toString'](0x10));
        targetPrice = ethers['BigNumber']['from'](hexer);
  
  
        if (transaction != null && transaction['data'].includes(token) && passed == 0) {
          if (transaction['data'].includes(buyMethod1) || transaction['data'].includes(buyMethod2) || transaction['data'].includes(buyMethod3)) {
  
            targetPriceDetected = targetPrice.lte(transaction.value);
            if (targetPriceDetected) {
  
              const frontrunGas = transaction.gasLimit.mul(2)
              const frontrunPrice = transaction.gasPrice.mul(2)
  
  
              console.log(chalk.green(`Start buying token...`))
              const buytx = await pcsRouterV2B.swapExactTokensForTokens(
                amountIn,
                amountOutMin,
                [WBNB, tokenAddress],
                myAddress,
                Date.now() + 1000 * 60 * 10,
                { gasLimit: frontrunGas, gasPrice: frontrunPrice, nonce: currentNonce++ }
              )
              passed = 1;
              await buytx.wait()
  
  
              console.log(chalk.green('Sucessfully bought the token!\n'))
              var balance = await getTokenBalance(tokenAddress, myAddress, provider)
  
              console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
              if (needApproval) {
                if (approveBeforeOrAfter == 2) {
                  console.log(chalk.green('Start approving token...'))
                  try {
                    const tx = await tokenContract.approve(
                      pcsRouterV2Addr,
                      ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
                      { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
                    )
                    await tx.wait()
                    console.log(chalk.green('Token spending approved. \n'))
                  } catch (e) {
                    console.log(e)
                    console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
                  }
                }
              }
  
              if (instantSell) {
                console.log(chalk.red(`Selling all the tokens...\n`))
                const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                  balance,
                  amountOutMin,
                  [tokenAddress, WBNB],
                  myAddress,
                  Date.now() + 1000 * 60 * 10,
                  { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
                )
  
                await selltx.wait()
                console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
                console.log(`You can check the transaction here:`)
                console.log(`https://bscscan.com/address/${myAddress}`)
                process.exit(0)
              } else {
                console.log(`You can check the transaction here:`)
                console.log(`https://bscscan.com/address/${myAddress}`)
                if (antiRug == true) {
                  startTime = Math.floor(Date.now() / 1000);
                  await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
                }
                if (antiRug == false) {
                  process.exit(0);
                }
              }
  
            }
  
          }
        }
  
      })
  
    })();
  } else if (choseMode == 4) {
    //run sell only mode
    (async () => {
      currentNonce = await getNonce(myAddress)
      let balanceWBNB = await getTokenBalance(WBNB, myAddress, provider)
      console.log(chalk.red(`WARNING: This Sniper mode is Sell Only.`))
      console.log(chalk.magenta("Oficial website: https://multisniperbot.com"));
      console.log(chalk.magenta(`For Support please join discord server on https://discord.gg/4qpbk4Jp.`));
      console.log(chalk.magenta(`Or old support group on telegram https://t.me/multisniperbots.`));
      console.log(chalk.green(`Connected to blockchain... \n`))
      console.log(chalk.green(`Sniper started with current settings:`))
      console.log(chalk.green('Sell token using ' + chalk.yellow(gasLimit) + ' Gas and ' + chalk.yellow(gasPrice / 1000000000) + ' Gwei'))
      console.log(chalk.green(`Total WBNB balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balanceWBNB, 18)).toFixed(6))}\n`))
      if (needApproval) {
        console.log(`Approve token: ` + chalk.green('YES'))
      } else {
        console.log(`Approve token: ` + chalk.red('NO'))
      }
      if (needApproval) {
  
        console.log(chalk.green('Start approving token...'))
        try {
          const tx = await tokenContract.approve(
            pcsRouterV2Addr,
            ethers.BigNumber.from("0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
            { gasLimit: gasLimitApprove, gasPrice: gasPriceApprove, nonce: currentNonce++ }
          )
          await tx.wait()
          console.log(chalk.green('Token spending approved. \n'))
        } catch (e) {
          console.log(e)
          console.log(chalk.red(`Unexpected error on approving, token is not approved !!! \n`))
        }
  
      }
  
      var balance = await getTokenBalance(tokenAddress, myAddress, provider)
  
      console.log(chalk.green(`Total Token balance is ${chalk.yellow(parseFloat(ethers.utils.formatUnits(balance, tokenDecimals)).toFixed(6))}\n`))
  
      if (instantSell) {
        if (antiRug == true & delaySell > 0) {
          startTime = Math.floor(Date.now() / 1000);
          await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
        } else {
          if (multipleSell == true) {
            if (txNumberForSell > 0) {
              balance = balance.div(txNumberForSell);
            }
            console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
            await new Promise(r => setTimeout(r, delayOnSellMs))
            for (i = 0; i < (txNumberForSell - 1); i++) {
              console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
              await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
                balance,
                amountOutMin,
                [tokenAddress, WBNB],
                myAddress,
                Date.now() + 1000 * 60 * 10,
                { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
              )
            }
            console.log(chalk.green(`Start selling token...`) + chalk.yellow(i + 1))
            const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
              balance,
              amountOutMin,
              [tokenAddress, WBNB],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
            )
            await selltx.wait()
            console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
            console.log(`You can check the transaction here:`)
            console.log(`https://bscscan.com/address/${myAddress}`)
            process.exit(0)
          } else {

            console.log(chalk.green(`Start selling all tokens in ` + chalk.yellow(delaySell) + ' second(s)'))
            await new Promise(r => setTimeout(r, delayOnSellMs))
            const selltx = await pcsRouterV2.swapExactTokensForETHSupportingFeeOnTransferTokens(
              balance,
              amountOutMin,
              [tokenAddress, WBNB],
              myAddress,
              Date.now() + 1000 * 60 * 10,
              { gasLimit: gasLimitSell, gasPrice: gasPriceSell, nonce: currentNonce++ }
            )
            await selltx.wait()
            console.log(chalk.green(`Sucessfully sold all the tokens !\n`))
            console.log(`You can check the transaction here:`)
            console.log(`https://bscscan.com/address/${myAddress}`)
            process.exit(0)
          }
        }
      } else {
        console.log(`You can check the transaction here:`)
        console.log(`https://bscscan.com/address/${myAddress}`)
        if (antiRug == true) {
          startTime = Math.floor(Date.now() / 1000);
          await monitorRugPull(balance, currentNonce, instantSell, delayOnSellMs, gasLimitSell, gasPriceSell, startTime);
        }
        if (antiRug == false) {
          process.exit(0);
        }
      }

  
    })();
  
  } else {
    console.log(`Please chose the corect mode to start the MultiSniper Plus!`)
    process.exit(0)
  }
}


