export interface Middleware<T> {
    (context: T, next: ContinuationMiddleware<T>): any;
}
export interface ContinuationMiddleware<T> {
    (context?: T, next?: Middleware<T>): any;
}
export declare function functionList<T = any>(list: Function | Function[], ...args: any[]): Middleware<T>[];
/**
 * Create a function to invoke all passed middleware functions
 * with a single argument <T>context
 * @param middleware
 */
export declare function compose<T = any>(...middleware: (Middleware<T> | Middleware<T>[])[]): ContinuationMiddleware<T>;
