"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFile = exports.ensureDottedRelative = exports.isNodeModule = exports.nodeModuleGlobs = exports.extraGlobs = exports.hasModuleGlobs = exports.isScript = void 0;
const path_1 = require("path");
const esmRegex = /(^\s*|[}\);\n]\s*)(import\s*(['"]|(\*\s+as\s+)?(?!type)([^"'\(\)\n; ]+)\s*from\s*['"]|\{)|export\s+\*\s+from\s+["']|export\s*(\{|default|function|class|var|const|let|async\s+function))/, moduleGlob = ['**/*', '!node_modules', '!test', '!**/*.d.ts'];
function isScript(code) {
    return !Boolean(code.match(esmRegex));
}
exports.isScript = isScript;
function hasModuleGlobs(file) {
    return nodeModuleGlobs(file) !== moduleGlob;
}
exports.hasModuleGlobs = hasModuleGlobs;
function extraGlobs(file) {
    var _a, _b, _c, _d;
    const globs = [];
    return globs
        .concat(...[((_b = (_a = file.package) === null || _a === void 0 ? void 0 : _a.pkg) === null || _b === void 0 ? void 0 : _b.scripts) || []])
        .concat(...[((_d = (_c = file.package) === null || _c === void 0 ? void 0 : _c.pkg) === null || _d === void 0 ? void 0 : _d.assets) || []]);
}
exports.extraGlobs = extraGlobs;
function nodeModuleGlobs(file, useDefault = true) {
    var _a;
    const normalGlobs = [].concat(...(((_a = file.package) === null || _a === void 0 ? void 0 : _a.files) || []));
    if (useDefault && !normalGlobs.length) {
        return moduleGlob;
    }
    return normalGlobs;
}
exports.nodeModuleGlobs = nodeModuleGlobs;
const notNodeModule = /^\.|^\//;
function isNodeModule(request) {
    return !notNodeModule.test(request);
}
exports.isNodeModule = isNodeModule;
function ensureDottedRelative(from, to) {
    let rel = path_1.relative(from, to);
    if (!rel.startsWith('.' + path_1.sep)) {
        rel = './' + rel;
    }
    return rel.split(path_1.sep).join('/');
}
exports.ensureDottedRelative = ensureDottedRelative;
function createFile(absPath) {
    return {
        size: 0,
        deps: {},
        absPath,
        contents: null,
        variableImports: false,
    };
}
exports.createFile = createFile;
//# sourceMappingURL=data:application/json;base64,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