"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gatherDependencies = void 0;
const meriyah_1 = require("meriyah");
const file_1 = require("./file");
function isNodeAString(node) {
    return Boolean(node && (node.type === 'Literal' || node.type === 'StringLiteral'));
}
function isRequire(node) {
    return node.callee.type === 'Identifier' && node.callee.name === 'require';
}
function isImport(node) {
    return node.callee.type === 'Import';
}
function walk(node, visit) {
    if (!node || typeof node.type !== 'string' || node._visited) {
        return;
    }
    visit(node);
    node._visited = true;
    for (const childNode in node) {
        const child = node[childNode];
        if (Array.isArray(child)) {
            for (let i = 0; i < child.length; i++) {
                walk(child[i], visit);
            }
        }
        else {
            walk(child, visit);
        }
    }
}
function gatherDependencies(code, isModule) {
    const result = {
        variable: false,
        deps: {},
    };
    if (!code) {
        return result;
    }
    const visit = (node) => {
        if (node.type === 'CallExpression' &&
            (isRequire(node) || isImport(node) || node.type === 'ImportExpression')) {
            const request = node.arguments[0];
            if (isNodeAString(request)) {
                result.deps[request.value] = null;
            }
            else {
                result.variable = true;
            }
        }
        if (node.type === 'ImportDeclaration' && isNodeAString(node.source)) {
            result.deps[node.source.value] = null;
        }
    }, options = {
        globalReturn: true,
        next: true,
        module: isModule || !file_1.isScript(code),
        specDeviation: true,
    };
    walk(meriyah_1.parse(code, options), visit);
    return result;
}
exports.gatherDependencies = gatherDependencies;
//# sourceMappingURL=data:application/json;base64,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