"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Loader = void 0;
const path_1 = require("path");
const node_builtins_1 = __importDefault(require("./node-builtins"));
const loader = __importStar(require("./node-loader"));
const file_1 = require("./file");
class Loader {
    constructor(options) {
        this.options = options;
    }
    loadEntry(workingDirectory, request, files = {}, warnings = []) {
        const mainFile = file_1.ensureDottedRelative(workingDirectory, path_1.resolve(workingDirectory, request));
        const entry = this.load(workingDirectory, mainFile, files, warnings);
        return { entry: entry, files, warnings };
    }
    load(cd, request, files = {}, warnings, context) {
        var _a;
        const options = { ...this.options };
        if (context) {
            Object.assign(options, { context });
        }
        const file = loader.load(cd, request, options);
        if ('warning' in file) {
            warnings.push(file.warning);
            return null;
        }
        if (files[file.absPath] !== undefined) {
            return files[file.absPath];
        }
        else {
            files[file.absPath] = file;
        }
        const packageGlobs = [];
        if (file.moduleRoot && file_1.hasModuleGlobs(file)) {
            packageGlobs.push(...file_1.nodeModuleGlobs(file, false));
        }
        if (!packageGlobs.length && file_1.hasModuleGlobs((file === null || file === void 0 ? void 0 : file.belongsTo) || {})) {
            packageGlobs.push(...file_1.nodeModuleGlobs(file.belongsTo || {}, false));
        }
        const fileDir = path_1.dirname(file.absPath), ctx = {
            moduleRoot: file.moduleRoot || ((_a = file.belongsTo) === null || _a === void 0 ? void 0 : _a.moduleRoot) || undefined,
            package: file.package,
            expanded: Boolean(file.contextExpanded),
            globs: packageGlobs,
        }, rejectBuiltins = (req) => {
            if (~node_builtins_1.default.indexOf(req)) {
                file.deps[req] = null;
                return false;
            }
            return true;
        };
        Object.keys(file.deps)
            .sort()
            .filter(rejectBuiltins)
            .map((req) => {
            const dep = (file.deps[req] = this.load(fileDir, req, files, warnings, ctx));
            if (dep) {
                dep.belongsTo = file.moduleRoot ? file : file.belongsTo;
            }
        });
        return file;
    }
}
exports.Loader = Loader;
//# sourceMappingURL=data:application/json;base64,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