"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const compose_1 = require("./compose");
exports.compose = compose_1.compose;
exports.functionList = compose_1.functionList;
class AppBuilder {
    constructor() {
        this.middleware = [];
    }
    build() {
        if (!this.middleware.length) {
            throw new Error('Usage error: must have at least one middleware');
        }
        return compose_1.compose(this.middleware);
    }
    use(mw) {
        if ('function' !== typeof mw) {
            throw new TypeError(`${mw}, must be a middleware function accpeting (context, next) arguments`);
        }
        this.middleware.push(mw);
        return this;
    }
}
exports.AppBuilder = AppBuilder;
function createAppBuilder() {
    return new AppBuilder();
}
exports.default = createAppBuilder;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwLWJ1aWxkZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvYXBwLWJ1aWxkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx1Q0FBcUY7QUF5QjVFLGtCQXpCQSxpQkFBTyxDQXlCQTtBQUFFLHVCQXpCb0Msc0JBQVksQ0F5QnBDO0FBdkI5QixNQUFhLFVBQVU7SUFBdkI7UUFDVSxlQUFVLEdBQXlCLEVBQUUsQ0FBQTtJQWdCL0MsQ0FBQztJQWRDLEtBQUs7UUFDSCxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLEVBQUU7WUFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxnREFBZ0QsQ0FBQyxDQUFBO1NBQ2xFO1FBQ0QsT0FBTyxpQkFBTyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQTtJQUNqQyxDQUFDO0lBRUQsR0FBRyxDQUFDLEVBQWlCO1FBQ25CLElBQUksVUFBVSxLQUFLLE9BQU8sRUFBRSxFQUFFO1lBQzVCLE1BQU0sSUFBSSxTQUFTLENBQUMsR0FBRyxFQUFFLHFFQUFxRSxDQUFDLENBQUE7U0FDaEc7UUFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQTtRQUN4QixPQUFPLElBQUksQ0FBQTtJQUNiLENBQUM7Q0FDRjtBQWpCRCxnQ0FpQkM7QUFFRCxTQUF3QixnQkFBZ0I7SUFDdEMsT0FBTyxJQUFJLFVBQVUsRUFBSyxDQUFBO0FBQzVCLENBQUM7QUFGRCxtQ0FFQyJ9