"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const flatten = (values) => [].concat(...values), noop = function noop() {
    return Promise.resolve();
};
function throwIfHasBeenCalled(fn) {
    if (fn.__appbuildercalled) {
        throw new Error('Cannot call next more than once');
    }
    return (fn.__appbuildercalled = true);
}
function tryInvokeMiddleware(context, middleware, next = noop) {
    try {
        return Promise.resolve(middleware ? middleware(context, next) : context);
    }
    catch (error) {
        return Promise.reject(error);
    }
}
function functionList(list, ...args) {
    const arrayList = Symbol.iterator in list ? Array.from(list) : [list];
    return arrayList.map((x) => {
        return (_, next) => Promise.resolve(x(...args)).then(next);
    });
}
exports.functionList = functionList;
/**
 * Create a function to invoke all passed middleware functions
 * with a single argument <T>context
 * @param middleware
 */
function compose(...middleware) {
    return flatten(middleware)
        .filter((x) => {
        if ('function' !== typeof x) {
            throw new TypeError(`${x}, must be a middleware function accpeting (context, next) arguments`);
        }
        return x;
    })
        .reduceRight((composed, mw) => {
        return function (context, nextFn) {
            const next = () => throwIfHasBeenCalled(next) && composed(context, nextFn);
            return tryInvokeMiddleware(context, mw, next);
        };
    }, tryInvokeMiddleware);
}
exports.compose = compose;
//# sourceMappingURL=data:application/json;base64,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