"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.load = exports.resolve = exports.resolveSync = void 0;
const fs = __importStar(require("fs"));
const globby_1 = require("globby");
const path_1 = require("path");
const gather_deps_1 = require("./gather-deps");
const file_1 = require("./file");
const enhanced_resolve_1 = require("enhanced-resolve");
const { readFileSync, lstatSync, statSync, realpathSync } = fs;
const fileSystem = new enhanced_resolve_1.CachedInputFileSystem(fs, 4000), resolver = enhanced_resolve_1.ResolverFactory.createResolver({
    extensions: ['.js', '.json', '.node'],
    conditionNames: ['node', 'require'],
    symlinks: false,
    fileSystem: new enhanced_resolve_1.CachedInputFileSystem(fs, 4000),
}), syncResolver = enhanced_resolve_1.ResolverFactory.createResolver({
    extensions: ['.js', '.json', '.node'],
    conditionNames: ['node', 'require'],
    useSyncFileSystemCalls: true,
    symlinks: false,
    fileSystem,
}), defaultOptions = { loadContent: true, expand: 'none', isEntry: false };
function scc(path) {
    return path && path.replace(/[\u0000-\u001F\u007F-\u009F]/g, '');
}
function resolveSync(from, request) {
    const result = {
        absPath: '',
        pkgPath: '',
        pkg: null,
        warning: '',
    };
    syncResolver.resolve({}, from, request, {}, (err, path, data) => {
        if (err) {
            result.warning = err.message;
            return;
        }
        result.absPath = scc(path);
        result.pkgPath = scc(data.descriptionFilePath);
        result.pkg = data.descriptionFileData;
        return;
    });
    return result;
}
exports.resolveSync = resolveSync;
function resolve(from, request) {
    const result = {
        absPath: '',
        pkgPath: '',
        pkg: null,
        warning: '',
    };
    return new Promise((resolve) => {
        resolver.resolve({}, from, request, {}, (err, path, data) => {
            if (err) {
                result.warning = err.message;
                return resolve(result);
            }
            result.absPath = path;
            result.pkgPath = data.descriptionFilePath;
            result.pkg = data.descriptionFileData;
            resolve(result);
        });
    });
}
exports.resolve = resolve;
async function expand(file, fileDir, baseDir, globs) {
    const files = globby_1.sync(globs, {
        cwd: baseDir,
        followSymbolicLinks: false,
    });
    files
        .sort() //glob search is width first and not deterministic
        .map((dep) => file_1.ensureDottedRelative(fileDir, path_1.join(baseDir, dep)))
        .filter((relDep) => file.absPath !== path_1.join(baseDir, relDep))
        .forEach((relDep) => {
        file.deps[relDep] = file.deps[relDep] || null;
    });
    const currentDeps = Object.keys(file.deps);
    file.package &&
        file.package.dependencies &&
        Object.keys(file.package.dependencies || {}).forEach((dependency) => {
            if (!currentDeps.some((curDep) => curDep.startsWith(dependency))) {
                file.deps[dependency] = file.deps[dependency] || null;
            }
        });
}
function load(workingDirectory, request, options = defaultOptions) {
    var _a;
    const { absPath, pkg, pkgPath, warning } = resolveSync(workingDirectory, request);
    if (!absPath) {
        return { warning: warning };
    }
    const file = file_1.createFile(absPath), isJs = absPath.endsWith('.js') || absPath.endsWith('.mjs') || options.isEntry;
    file.absPath = absPath;
    if (isJs || absPath.endsWith('json')) {
        file.contents = readFileSync(absPath, 'utf-8');
    }
    if (isJs) {
        try {
            const parseResult = gather_deps_1.gatherDependencies(file.contents, absPath.endsWith('.mjs'));
            Object.assign(file.deps, parseResult.deps);
            file.variableImports = parseResult.variable;
        }
        catch (e) {
            return { warning: `Error parsing file: "${file.absPath}"\n${e.stack}` };
        }
    }
    const fileDir = path_1.dirname(file.absPath), expandVariable = Boolean(options.expand === 'variable' && file.variableImports);
    if (file_1.isNodeModule(request) && pkg && pkgPath) {
        file.package = pkg;
        file.deps[file_1.ensureDottedRelative(fileDir, pkgPath)] = null;
        const pkgDir = (file.moduleRoot = path_1.dirname(pkgPath)), expandAll = options.expand === 'all';
        if (expandVariable || expandAll) {
            expand(file, fileDir, pkgDir, file_1.nodeModuleGlobs(file));
            file.contextExpanded = true;
        }
        if (file_1.extraGlobs(file).length) {
            expand(file, fileDir, pkgDir, file_1.extraGlobs(file));
        }
    }
    else if (expandVariable && ((_a = options.context) === null || _a === void 0 ? void 0 : _a.moduleRoot) && !options.context.expanded) {
        expand(file, fileDir, options.context.moduleRoot, file_1.nodeModuleGlobs({ package: { files: options.context.globs } }));
        file.contextExpanded = true;
    }
    if (!options.loadContent) {
        file.contents = null;
    }
    const stats = lstatSync(file.absPath);
    if (stats.isSymbolicLink()) {
        const path = realpathSync(file.absPath);
        const absStat = statSync(file.absPath);
        file.realPath = path;
        file.realSize = absStat.size;
    }
    file.size = stats.size;
    return file;
}
exports.load = load;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9kZS1sb2FkZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvbm9kZS1sb2FkZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUFBLHVDQUF3QjtBQUN4QixtQ0FBcUM7QUFDckMsK0JBQW9DO0FBQ3BDLCtDQUFrRDtBQUNsRCxpQ0FRZTtBQUNmLHVEQUF5RTtBQUV6RSxNQUFNLEVBQUUsWUFBWSxFQUFFLFNBQVMsRUFBRSxRQUFRLEVBQUUsWUFBWSxFQUFFLEdBQUcsRUFBRSxDQUFBO0FBTTlELE1BQU0sVUFBVSxHQUFHLElBQUksd0NBQXFCLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBUSxFQUMzRCxRQUFRLEdBQUcsa0NBQWUsQ0FBQyxjQUFjLENBQUM7SUFDeEMsVUFBVSxFQUFFLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSxPQUFPLENBQUM7SUFDckMsY0FBYyxFQUFFLENBQUMsTUFBTSxFQUFFLFNBQVMsQ0FBQztJQUNuQyxRQUFRLEVBQUUsS0FBSztJQUNmLFVBQVUsRUFBRSxJQUFJLHdDQUFxQixDQUFDLEVBQUUsRUFBRSxJQUFJLENBQVE7Q0FDdkQsQ0FBYSxFQUNkLFlBQVksR0FBRyxrQ0FBZSxDQUFDLGNBQWMsQ0FBQztJQUM1QyxVQUFVLEVBQUUsQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFLE9BQU8sQ0FBQztJQUNyQyxjQUFjLEVBQUUsQ0FBQyxNQUFNLEVBQUUsU0FBUyxDQUFDO0lBQ25DLHNCQUFzQixFQUFFLElBQUk7SUFDNUIsUUFBUSxFQUFFLEtBQUs7SUFDZixVQUFVO0NBQ1gsQ0FBYSxFQUNkLGNBQWMsR0FBNkIsRUFBRSxXQUFXLEVBQUUsSUFBSSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsT0FBTyxFQUFFLEtBQUssRUFBRSxDQUFBO0FBSWxHLFNBQVMsR0FBRyxDQUFDLElBQVk7SUFDdkIsT0FBTyxJQUFJLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQywrQkFBK0IsRUFBRSxFQUFFLENBQUMsQ0FBQTtBQUNsRSxDQUFDO0FBRUQsU0FBZ0IsV0FBVyxDQUFDLElBQVksRUFBRSxPQUFlO0lBQ3ZELE1BQU0sTUFBTSxHQUFHO1FBQ2IsT0FBTyxFQUFFLEVBQUU7UUFDWCxPQUFPLEVBQUUsRUFBRTtRQUNYLEdBQUcsRUFBRSxJQUFJO1FBQ1QsT0FBTyxFQUFFLEVBQUU7S0FDWixDQUFBO0lBQ0QsWUFBWSxDQUFDLE9BQU8sQ0FBQyxFQUFFLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxFQUFFLEVBQUUsQ0FBQyxHQUFpQixFQUFFLElBQVksRUFBRSxJQUFTLEVBQUUsRUFBRTtRQUN6RixJQUFJLEdBQUcsRUFBRTtZQUNQLE1BQU0sQ0FBQyxPQUFPLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQTtZQUM1QixPQUFNO1NBQ1A7UUFDRCxNQUFNLENBQUMsT0FBTyxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQTtRQUMxQixNQUFNLENBQUMsT0FBTyxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQTtRQUM5QyxNQUFNLENBQUMsR0FBRyxHQUFHLElBQUksQ0FBQyxtQkFBbUIsQ0FBQTtRQUNyQyxPQUFNO0lBQ1IsQ0FBQyxDQUFDLENBQUE7SUFDRixPQUFPLE1BQU0sQ0FBQTtBQUNmLENBQUM7QUFsQkQsa0NBa0JDO0FBRUQsU0FBZ0IsT0FBTyxDQUFDLElBQVksRUFBRSxPQUFlO0lBQ25ELE1BQU0sTUFBTSxHQUFHO1FBQ2IsT0FBTyxFQUFFLEVBQUU7UUFDWCxPQUFPLEVBQUUsRUFBRTtRQUNYLEdBQUcsRUFBRSxJQUFJO1FBQ1QsT0FBTyxFQUFFLEVBQUU7S0FDWixDQUFBO0lBQ0QsT0FBTyxJQUFJLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFBRSxFQUFFO1FBQzdCLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsRUFBRSxFQUFFLENBQUMsR0FBaUIsRUFBRSxJQUFZLEVBQUUsSUFBUyxFQUFFLEVBQUU7WUFDckYsSUFBSSxHQUFHLEVBQUU7Z0JBQ1AsTUFBTSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFBO2dCQUM1QixPQUFPLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQTthQUN2QjtZQUNELE1BQU0sQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFBO1lBQ3JCLE1BQU0sQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFBO1lBQ3pDLE1BQU0sQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFBO1lBQ3JDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQTtRQUNqQixDQUFDLENBQUMsQ0FBQTtJQUNKLENBQUMsQ0FBQyxDQUFBO0FBQ0osQ0FBQztBQW5CRCwwQkFtQkM7QUFFRCxLQUFLLFVBQVUsTUFBTSxDQUFDLElBQVUsRUFBRSxPQUFlLEVBQUUsT0FBZSxFQUFFLEtBQXdCO0lBQzFGLE1BQU0sS0FBSyxHQUFHLGFBQUksQ0FBQyxLQUFLLEVBQUU7UUFDeEIsR0FBRyxFQUFFLE9BQU87UUFDWixtQkFBbUIsRUFBRSxLQUFLO0tBQzNCLENBQUMsQ0FBQTtJQUNGLEtBQUs7U0FDRixJQUFJLEVBQUUsQ0FBQyxrREFBa0Q7U0FDekQsR0FBRyxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQywyQkFBb0IsQ0FBQyxPQUFPLEVBQUUsV0FBSSxDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsQ0FBQyxDQUFDO1NBQy9ELE1BQU0sQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sS0FBSyxXQUFJLENBQUMsT0FBTyxFQUFFLE1BQU0sQ0FBQyxDQUFDO1NBQzFELE9BQU8sQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFO1FBQ2xCLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxJQUFJLENBQUE7SUFDL0MsQ0FBQyxDQUFDLENBQUE7SUFDSixNQUFNLFdBQVcsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQTtJQUMxQyxJQUFJLENBQUMsT0FBTztRQUNWLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWTtRQUN6QixNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxJQUFJLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLFVBQVUsRUFBRSxFQUFFO1lBQ2xFLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLEVBQUU7Z0JBQ2hFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxJQUFJLENBQUE7YUFDdEQ7UUFDSCxDQUFDLENBQUMsQ0FBQTtBQUNOLENBQUM7QUFFRCxTQUFnQixJQUFJLENBQ2xCLGdCQUF3QixFQUN4QixPQUFlLEVBQ2YsT0FBTyxHQUFHLGNBQWM7O0lBRXhCLE1BQU0sRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsR0FBRyxXQUFXLENBQUMsZ0JBQWdCLEVBQUUsT0FBTyxDQUFDLENBQUE7SUFDakYsSUFBSSxDQUFDLE9BQU8sRUFBRTtRQUNaLE9BQU8sRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLENBQUE7S0FDNUI7SUFFRCxNQUFNLElBQUksR0FBRyxpQkFBVSxDQUFDLE9BQU8sQ0FBQyxFQUM5QixJQUFJLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxPQUFPLENBQUMsUUFBUSxDQUFDLE1BQU0sQ0FBQyxJQUFJLE9BQU8sQ0FBQyxPQUFPLENBQUE7SUFFL0UsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUE7SUFFdEIsSUFBSSxJQUFJLElBQUksT0FBTyxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNwQyxJQUFJLENBQUMsUUFBUSxHQUFHLFlBQVksQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUE7S0FDL0M7SUFFRCxJQUFJLElBQUksRUFBRTtRQUNSLElBQUk7WUFDRixNQUFNLFdBQVcsR0FBRyxnQ0FBa0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLE9BQU8sQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQTtZQUMvRSxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFBO1lBQzFDLElBQUksQ0FBQyxlQUFlLEdBQUcsV0FBVyxDQUFDLFFBQVEsQ0FBQTtTQUM1QztRQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQ1YsT0FBTyxFQUFFLE9BQU8sRUFBRSx3QkFBd0IsSUFBSSxDQUFDLE9BQU8sTUFBTSxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQTtTQUN4RTtLQUNGO0lBRUQsTUFBTSxPQUFPLEdBQUcsY0FBTyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsRUFDbkMsY0FBYyxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsTUFBTSxLQUFLLFVBQVUsSUFBSSxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUE7SUFFakYsSUFBSSxtQkFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsSUFBSSxPQUFPLEVBQUU7UUFDM0MsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUE7UUFDbEIsSUFBSSxDQUFDLElBQUksQ0FBQywyQkFBb0IsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUE7UUFDeEQsTUFBTSxNQUFNLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBVSxHQUFHLGNBQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxFQUNqRCxTQUFTLEdBQUcsT0FBTyxDQUFDLE1BQU0sS0FBSyxLQUFLLENBQUE7UUFDdEMsSUFBSSxjQUFjLElBQUksU0FBUyxFQUFFO1lBQy9CLE1BQU0sQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLE1BQU0sRUFBRSxzQkFBZSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUE7WUFDcEQsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUE7U0FDNUI7UUFDRCxJQUFJLGlCQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxFQUFFO1lBQzNCLE1BQU0sQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFLE1BQU0sRUFBRSxpQkFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUE7U0FDaEQ7S0FDRjtTQUFNLElBQUksY0FBYyxLQUFJLE1BQUEsT0FBTyxDQUFDLE9BQU8sMENBQUUsVUFBVSxDQUFBLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRTtRQUNyRixNQUFNLENBQ0osSUFBSSxFQUNKLE9BQU8sRUFDUCxPQUFPLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFDMUIsc0JBQWUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxFQUFFLEtBQUssRUFBRSxPQUFPLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FDL0QsQ0FBQTtRQUNELElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFBO0tBQzVCO0lBRUQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUU7UUFDeEIsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUE7S0FDckI7SUFDRCxNQUFNLEtBQUssR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFBO0lBQ3JDLElBQUksS0FBSyxDQUFDLGNBQWMsRUFBRSxFQUFFO1FBQzFCLE1BQU0sSUFBSSxHQUFHLFlBQVksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUE7UUFDdkMsTUFBTSxPQUFPLEdBQUcsUUFBUSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQTtRQUN0QyxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQTtRQUNwQixJQUFJLENBQUMsUUFBUSxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUE7S0FDN0I7SUFDRCxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUE7SUFDdEIsT0FBTyxJQUFJLENBQUE7QUFDYixDQUFDO0FBbEVELG9CQWtFQyJ9